/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

float noise(in vec2 pos)
{
    //return fract(sin(dot(pos ,vec2(12.9898,78.233))) * 43758.5453);
    return fract( sin( dot(pos*0.001 ,vec2(24.12357, 36.789) ) ) * 12345.123);
}

float smooth_noise(vec2 pos)
{
    float corners = (noise(vec2(pos.x-1.0, pos.y-1.0)) + 
                    noise(vec2(pos.x+1.0, pos.y-1.0)) + 
                    noise(vec2(pos.x-1.0, pos.y+1.0)) + 
                   	noise(vec2(pos.x+1.0, pos.y+1.0)))/16.0;
                          
	float sides = (noise(vec2(pos.x-1.0, pos.y)) + noise(vec2(pos.x+1.0, pos.y)) +
                  noise(vec2(pos.x, pos.y-1.0)) + noise(vec2(pos.x, pos.y+1.0))) / 8.0;
                          
	float centre = noise(vec2(pos.x,pos.y)) / 4.0;
    
    return centre + sides + corners;                                
}

float interpolate_noise(vec2 pos)
{
	float a, b, c, d;
    
    a = smooth_noise(floor(pos));
    b = smooth_noise(vec2(floor(pos.x+1.0), floor(pos.y)));
    c = smooth_noise(vec2(floor(pos.x), floor(pos.y+1.0)));
    d = smooth_noise(vec2(floor(pos.x+1.0), floor(pos.y+1.0)));
    
    a = mix(a, b, fract(pos.x));
    b = mix(c, d, fract(pos.x));
    a = mix(a, b, fract(pos.y));
    
    return a;
}

float fbm_interpolated(vec2 pos)
{
    float f = 0.0;
    
    f += 0.5000 * interpolate_noise(pos); pos *= 0.203;
    f += 0.2500 * interpolate_noise(pos); pos *= 0.202;
    f += 0.1250 * interpolate_noise(pos); pos *= 0.201;
    f += 0.0625 * interpolate_noise(pos); pos *= 0.204;
    f /= 0.9375;
    
    return f;
}

float fbm(vec2 pos)
{
    float f = 0.0;
    
    f += 0.5000 * smooth_noise(pos); pos *= 0.203;
    f += 0.2500 * smooth_noise(pos); pos *= 0.202;
    f += 0.1250 * smooth_noise(pos); pos *= 0.201;
    f += 0.0625 * smooth_noise(pos); pos *= 0.204;
    f /= 0.9375;
    
    return f;
}

void main(void)
{
    vec2 pos = gl_FragCoord.xy;
	vec2 uv = pos / iResolution.xy;
    vec2 p = -1.0 + 2.0 * uv;
    
    float a = atan(p.y, p.x);
    
    p.x *= iResolution.x / iResolution.y;
    
    vec3 color = vec3(1.0);
    
    float r = sqrt(dot(p, p));
    
    float ss = 0.5 + 0.5*sin(4.0 * iGlobalTime);
    float anim = 1.0 + 0.1* ss * clamp(1.0-r, 0.0, 1.0);
    r *= anim;
    
    if(r < 0.8)
    {
        color = vec3(0.0, 0.3, 0.4);
        float f = fbm_interpolated(15.0 * p);
        color = mix(color, vec3(0.2, 0.5, 0.4), f);
        
        f = 1.0 - smoothstep(0.2, 0.5, r);
        color = mix(color, vec3(0.9, 0.4, 0.2), f);
        
        a += 0.1 + fbm_interpolated(6.0 * p);
        
        f = smoothstep(0.3, 1.0, fbm_interpolated(vec2(6.0*r, 20.0*a)));
        color = mix(color, vec3(1.0), f);
        
        f = smoothstep(0.4, 0.9, fbm_interpolated(vec2(8.0*r, 45.0*a)));
        color *= 1.0 - f;
        
        f = smoothstep(0.5, 0.95, r);
        color *= 1.0 - 0.5 * f;
        
        f = smoothstep(0.2, 0.25, r);
        color *= f;
        
        f = 1.0 - smoothstep(0.0, 0.5, length(p - vec2(0.3, 0.3)));
        color += vec3(1.0, 0.9, 0.8) * f * 0.9;
        
        f = smoothstep(0.75, 0.8, r);
        color = mix(color, vec3(1.0), f);
    }
    
    gl_FragColor = vec4(color, 1.0);

}